#!/bin/sh
# File created: 2009-03-11 00:34:12

header_dir=$1
header_full=$2
target=$3

if [ -z "$target" ]; then
	echo "$0: three arguments please"
	exit 1
fi

if [ ! -f "$header_full" ]; then
	echo "$0: no such file '$header_full'"
	exit 1
fi

header=`echo $header_full | sed "s:^$header_dir/\{1,\}::"`

tmp=`mktemp`

echo "#include <$header>" > $tmp
for const in `cat $header_full`; do
	echo "'$const' = $const" >> $tmp
done

mkdir -p `dirname $target`
echo -n "; This file was automatically generated by $0 " > $target
date >> $target
LC_ALL=C cpp -P $tmp | sort -u >> $target
sed -i "/^[^';]/d; /^$/d; s/'//g; s/= 0\([^x].*\)/= \1o/" $target

rm -f $tmp
