-- File created: 2008-02-24 21:12:25

module Coadjute.Util.Monad (anyM, allM, whenM, whileM, untilM) where

import Control.Monad (liftM, when)

anyM, allM :: (Monad m) => (a -> m Bool) -> [a] -> m Bool
anyM _ []     = return False
anyM p (x:xs) = p x >>= \b -> if b then return True else anyM p xs

allM _ []     = return True
allM p (x:xs) = p x >>= \b -> if b then allM p xs else return False

whenM :: (Monad m) => m Bool -> m a -> m ()
whenM cond body = cond >>= \c -> when c (body >> return ())

whileM, untilM :: (Monad m) => m Bool -> m a -> m ()
whileM cond body = whenM cond (body >> whileM cond body)

untilM = whileM . liftM not
