// File created: 2007-11-06 17:04:50

package ope.adventure.ui;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import ope.adventure.Area;
import ope.adventure.Adventure;
import ope.adventure.Player;
import ope.adventure.util.Utils;

public final class SimpleUI {
	public static void main(final String[] args) throws Exception {

		final BufferedReader
			reader = new BufferedReader(new InputStreamReader(System.in));

		final Adventure adv = new Adventure();
		final Player player = adv.getPlayer();
		Area area = null;
		
		System.out.printf("%n%s%n%n", adv.getWelcome());

		while (!adv.isOver()) {
			if (player.getLocation() != area) {
				area = player.getLocation();
				print(area);
			}

			System.out.printf("%n> ");

			final String output = adv.playTurn(reader.readLine());

			System.out.println();
			if (output.length() > 0)
				System.out.printf("%s%n", output);
		}
	}

	private static void print(final Area area) {
		System.out.println(area.getName());
		System.out.println(area.getFullDescription());
	}
}
