// File created: 2007-10-20 20:58:30

package ope.adventure.book;

import java.util.List;
import java.util.regex.Pattern;

public final class ID {
	private ID(){}

	private static final Pattern
		BOOKID_REGEX = Pattern.compile("^[0-9]+$"),
		SECTID_REGEX = Pattern.compile("^[A-Za-z]+$");

	public static boolean isBookId(final String s) {
		return BOOKID_REGEX.matcher(s).matches();
	}
	public static boolean isSectionId(final String s) {
		return SECTID_REGEX.matcher(s).matches();
	}

	private static int bookId = 0;

	public static void resetBookId() { bookId = 0; }
	public static int  nextBookId()  { return bookId++; }

	public static Book getBook(
		final String id,
		final List<Book> books
	) {
		try {
			return books.get(Integer.parseInt(id));
		} catch (final Exception e) {
			return null;
		}
	}

	private static final StringBuilder sectionId = new StringBuilder(7);

	static {
		sectionId.setLength(sectionId.capacity());
	}

	public static void resetSectionId() {
		// '`' == 'a'-1
		sectionId.replace(0, sectionId.length(), "`");
	}

	public static String nextSectionId() {
		int i;
		for (i = sectionId.length(); i-- > 0;) {
			if (sectionId.charAt(i) == 'z')
				sectionId.setCharAt(i, 'a');
			else {
				sectionId.setCharAt(i, (char)(sectionId.charAt(i) + 1));
				break;
			}
		}

		return sectionId.substring(i, sectionId.length());
	}

	public static BookSection getSection(
		final String id,
		final List<BookSection> sections
	) {
		if (sections == null)
			return null;

		final int idx = idToIndex(id);
		if (idx >= 0 && idx < sections.size())
			return sections.get(idx);
		else
			return null;
	}

	//   a ->   0
	//   z ->  25
	//  aa ->  26
	//  za -> 676
	//  zz -> 701
	// aaa -> 702
	// least significant char is 0-25, otherwise 1-26.
	private static int idToIndex(final String id) {
		if (id.length() == 0)
			return -1;

		int i = id.length() - 1;
		int idx = id.charAt(i) - 'a';

		if (idx < 0 || idx > 25)
			return -1;

		while (i-- > 0) {
			++idx;
			idx *= 26;

			final int n = id.charAt(i) - 'a';
			if (n < 0 || n > 25)
				return -1;

			idx += n;
		}
		return idx;
	}
}
