// File created: 2007-10-22 15:05:46

package ope.adventure.actions;

import java.io.PrintStream;
import java.util.List;

import ope.adventure.Action;
import ope.adventure.Configuration;
import ope.adventure.Player;

// "reload"
public final class ReloadAction extends Action {
	public boolean doableWithoutBooks () { return true; }
	public boolean doableWithoutSpells() { return true; }
	public boolean stopReading        () { return true; }

	public String getShortHelp() {
		return "reload all game data";
	}
	public String getLongHelp() {
		return
			"\"reload\"\n" +
			"\n" +
			"Reloads the configuration file config.cfg as well as all game " +
			"data. This\nincludes books, entities, spells, and assignments." +
			"\n\n" +
			"Read the developer's documentation (provided as in-game books) for " +
			"details.";
	}

	public int perform(
		final List<String> words,
		final Configuration config, final Player player
	) {
		ignoringExcess(words, 0);

		final PrintStream stderr = System.err;
		System.setErr(super.replaceStderr);

		System.err.println("Reloading...");

		config.reconfigure();

		System.setErr(stderr);

		// these may reference old books
		player.setNextBooks   (null);
		player.setNextSections(null);
		player.setNextSnippets(null);

		println("Reloaded.");

		return 0;
	}
}
