// File created: 2007-10-25 13:08:37

package ope.adventure.actions;

import java.util.List;

import ope.adventure.Action;
import ope.adventure.Configuration;
import ope.adventure.Player;
import ope.adventure.util.Utils;

// "memorize" word spell...
public final class MemorizeAction extends Action {
	public boolean doableWithoutBooks () { return true; }
	public boolean doableWithoutSpells() { return true; }
	public boolean stopReading        () { return false; }

	public String getShortHelp() {
		return "memorize a spell into a more memorable form";
	}
	public String getLongHelp() {
		return
			"\"memorize\" word spell\n" +
			"\"alias\" word spell\n" +
			"\n" +
			"Memorize spell as word: using \"cast word\" will have the same " +
			"effect as \"cast\nspell\". Keep in mind that word must be one word.";
	}

	public int perform(
		final List<String> words,
		final Configuration config, final Player player
	) {
		if (words.size() < 2) {
			println(
				"Need a word to memorize the spell as, as well as the spell.");
			return 0;
		}

		final String as = words.get(0);
		final String cant = Utils.toLower(Utils.join(
			words.subList(1, words.size()), " "));

		player.memorize(cant, as);

		printfln("Memorized '%s' as '%s'.", cant, as);

		return 0;
	}
}
